	function onInit()
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_StunStick.Swing" )
	end

	-- 1 = Arrest
	-- 2 = Unarrest
	-- 3 = Remove Weapons
	function onPrimaryAttack()
		_PlayerViewModelSequence(Owner, ACT_VM_HITCENTER)
		_RunString("RoleplayData.Arrest("..Owner..", 1)")
	end

	function onSecondaryAttack()
		_PlayerViewModelSequence(Owner, ACT_VM_HITCENTER)
		_RunString("RoleplayData.Arrest("..Owner..", 2)")
	end

	function onReload()
		_RunString("RoleplayData.Arrest("..Owner..", 3)")
	end
	
	function onPickup(playerid)
		_RunString([[
		if RoleplayData[]]..playerid..[[].Team == TEAM_RED then
		_EntRemove(]]..MyIndex..[[)
		end
		]])
	end
	
	
	function onDrop(playerid)
		_EntRemove(MyIndex)
	end
	
	
	function getHUDMaterial() 
		return "UCRPM/SWEP/arreststick" 
	end
	
	function getWeaponSwapHands()
		return false;	
	end
	

	function getWeaponFOV()

		return 74;	

	end

	

	function getWeaponSlot()

		return 3;	

	end

	

	function getWeaponSlotPos()

		return 1;	

	end

	

	function getFiresUnderwater()

		return true;

	end

	

	function getReloadsSingly()

		return false;

	end

	

	function getDamage()

		return 0;

	end

	

	function getPrimaryShotDelay()

		return 0.7;

	end

	

	function getSecondaryShotDelay()

		return 0.7;

	end

	

	function getPrimaryIsAutomatic()

		return false;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpread()

		return vector3( 0.001, 0.001, 0.001 );

	end

	

	function getViewKick()

		return vector3( -0.3, 0.0, 0.0);

	end

	

	function getViewKickRandom()

		return vector3( -0.2, 0.2, 0.2 );

	end

	

	

	function getBulletSpreadSecondary()

		return vector3( 0.001, 0.001, 0.001 );

	end

	

	function getViewKickSecondary()

		return vector3( 0.0, 0.0, 0.0);

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.0, 0.0, 0.0 );

	end
	
	
	function getViewModel( )
		return "models/weapons/v_stunstick.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_stunbaton.mdl";
	end



	function getClassName()

		return "weapon_rp_arrest";

	end



	function getPrimaryAmmoType()

		return "none";

	end

		

	function getSecondaryAmmoType()

		return "none";

	end

	

	-- return -1 if it doesn't use clips

	function getMaxClipPrimary()

		return 12;

	end

	

	function getMaxClipSecondary()

		return -1;

	end

	

	-- ammo in gun by default

	function getDefClipPrimary()

		return 64;

	end

	

	function getDefClipSecondary()

		return -1;

	end



	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade

	function getAnimPrefix()

		return "melee";

	end



	function getPrintName()

		return "Arrest Stick";

	end

	


	-- 0 = Don't override, shoot bullets, make sound and flash

	-- 1 = Don't shoot bullets but do make flash/sounds

	-- 2 = Only play animations

	-- 3 = Don't do anything

	

	function getPrimaryScriptOverride()

		return 1;

	end



	function getSecondaryScriptOverride()

		return 1;

	end
